/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.biome.utils;

import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.terraforged.mod.biome.utils.BiomeBuilder;
import com.terraforged.mod.featuremanager.util.codec.Codecs;
import com.terraforged.mod.util.reflect.Accessor;
import com.terraforged.mod.util.reflect.FieldAccessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.registries.ForgeRegistries;

public class BiomeUtils {
    private static final Codec<Biome.Climate> CLIMATE_CODEC = Biome.Climate.field_242459_a.codec();
    private static final Map<RegistryKey<Biome>, BiomeBuilder> BUILDERS = new HashMap<RegistryKey<Biome>, BiomeBuilder>();
    private static final FieldAccessor<Biome, Biome.Climate> CLIMATE_ACCESSOR = Accessor.field(Biome.class, Biome.Climate.class);

    public static BiomeBuilder getBuilder(RegistryKey<Biome> biome) {
        return BUILDERS.computeIfAbsent(biome, BiomeUtils::copy).init();
    }

    public static BiomeBuilder copy(RegistryKey<Biome> key) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(key.func_240901_a_());
        if (biome == null) {
            throw new NullPointerException(key.func_240901_a_().toString());
        }
        BiomeBuilder builder = new BiomeBuilder(key, biome);
        builder.func_205420_b(biome.func_185360_m());
        builder.func_205421_a(biome.func_185355_j());
        builder.func_205419_a(biome.func_201856_r());
        builder.func_235097_a_(biome.func_235089_q_());
        Biome.Climate climate = BiomeUtils.getClimate(biome);
        builder.func_205417_d(climate.field_242463_e);
        builder.func_205414_c(climate.field_242461_c);
        builder.func_205415_a(climate.field_242460_b);
        builder.func_242456_a(climate.field_242462_d);
        builder.func_242458_a(biome.func_242433_b());
        return builder;
    }

    private static Biome.Climate getClimate(Biome biome) {
        try {
            return CLIMATE_ACCESSOR.get(biome);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            try {
                JsonElement json = (JsonElement)Codecs.encodeAndGet(Biome.field_242418_b, biome, JsonOps.INSTANCE);
                return Codecs.decodeAndGet(CLIMATE_CODEC, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)json));
            }
            catch (Throwable t) {
                t.printStackTrace();
                return new Biome.Climate(Biome.RainType.RAIN, 0.5f, Biome.TemperatureModifier.NONE, 0.5f);
            }
        }
    }
}

